/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import com.moulberry.axiomclientapi.pathers.BallShape;
import com.moulberry.axiomclientapi.pathers.ToolPatherUnique;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ToolPatherSurface
implements ToolPatherUnique {
    private final int[] sphere;
    private final int[][] cardinal;
    private final Position2dToIntMap heightMap = new Position2dToIntMap(Integer.MIN_VALUE);
    private final Position2dToIntMap maxHeightMap = new Position2dToIntMap(Integer.MIN_VALUE);
    private final PositionSet checked = new PositionSet();
    private MaskContext maskContext = null;
    private class_2338.class_2339 lastPosition = null;
    private class_243 lastLookDirection = null;
    private final MaskElement maskElement;

    public ToolPatherSurface(int radius, BallShape ballShape) {
        this(radius, ballShape, null);
    }

    public ToolPatherSurface(int radius, BallShape ballShape, MaskElement mask) {
        radius = Math.max(0, radius);
        this.maskElement = mask;
        IntArrayList sphere = new IntArrayList();
        List<IntArrayList> cardinal = List.of(new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList());
        float radiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int z = -radius; z <= radius; ++z) {
                for (int y = radius; y >= 0; --y) {
                    IntList list;
                    float distanceSq = ballShape.distanceSq(x, y, z);
                    if (!(distanceSq <= radiusSq)) continue;
                    sphere.add(x);
                    sphere.add(y);
                    sphere.add(z);
                    if (x <= 0) {
                        list = (IntList)cardinal.get(0);
                        list.add(x);
                        list.add(y);
                        list.add(z);
                    }
                    if (z <= 0) {
                        list = (IntList)cardinal.get(1);
                        list.add(x);
                        list.add(y);
                        list.add(z);
                    }
                    if (x >= 0) {
                        list = (IntList)cardinal.get(2);
                        list.add(x);
                        list.add(y);
                        list.add(z);
                    }
                    if (z < 0) continue block1;
                    list = (IntList)cardinal.get(3);
                    list.add(x);
                    list.add(y);
                    list.add(z);
                    continue block1;
                }
            }
        }
        this.sphere = sphere.toIntArray();
        this.cardinal = new int[4][];
        for (int i = 0; i < 4; ++i) {
            this.cardinal[i] = ((IntList)cardinal.get(i)).toIntArray();
        }
    }

    public boolean update(TriIntConsumer consumer) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().method_1560()) {
            return false;
        }
        class_243 lookDirection = null;
        if (EditorUI.isActive()) {
            if (EditorUI.isMovingCamera()) {
                return false;
            }
            lookDirection = EditorUI.getMouseLookVector();
        } else if (class_310.method_1551().method_1560() != null) {
            lookDirection = class_310.method_1551().method_1560().method_5720();
        }
        if (lookDirection == null) {
            return false;
        }
        class_243 start = entity.method_33571();
        boolean includeFluids = Tool.defaultIncludeFluids();
        class_1937 level = entity.method_37908();
        if (this.maskContext == null) {
            this.maskContext = new MaskContext(level);
        }
        if (this.lastLookDirection == null || this.lastPosition == null) {
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(level, start.method_46409(), lookDirection.method_46409(), false, includeFluids, false);
            if (raycastResult != null) {
                this.lastLookDirection = lookDirection;
                this.lastPosition = raycastResult.getBlockPos().method_25503();
                for (int i = 0; i < this.sphere.length; i += 3) {
                    int x2 = this.sphere[i] + this.lastPosition.method_10263();
                    int h2 = this.sphere[i + 1];
                    int z2 = this.sphere[i + 2] + this.lastPosition.method_10260();
                    int fromY = this.lastPosition.method_10264() - h2;
                    int toY = this.lastPosition.method_10264() + h2;
                    boolean updateMaxY = false;
                    int minY = this.heightMap.get(x2, z2) + 1;
                    int maxY = level.method_8624(class_2902.class_2903.field_13197, x2, z2) - 1;
                    if (fromY < minY) {
                        fromY = minY;
                    }
                    if (toY >= maxY) {
                        toY = maxY;
                        updateMaxY = true;
                    }
                    for (int y2 = toY; y2 >= fromY; --y2) {
                        if (!this.checked.add(x2, y2, z2)) continue;
                        this.maskContext.reset();
                        if (!this.maskContext.getBlockState(x2, y2, z2).method_51366() || this.maskContext.getBlockState(x2, y2, z2, 0, 1, 0).method_51366() || this.maskElement != null && !this.maskElement.test(this.maskContext, x2, y2, z2)) continue;
                        if (updateMaxY) {
                            maxY = y2;
                        }
                        this.heightMap.put(x2, z2, y2);
                        consumer.accept(x2, y2, z2);
                        break;
                    }
                    this.maxHeightMap.put(x2, z2, maxY);
                }
            }
            return true;
        }
        BooleanWrapper changed = new BooleanWrapper(false);
        double dot = this.lastLookDirection.method_1026(lookDirection);
        double angleChange = Math.toDegrees(Math.acos(dot));
        int steps = 1;
        if (angleChange > 1.0) {
            steps = (int)Math.ceil(angleChange);
        }
        for (int i = 1; i <= steps; ++i) {
            float f = (float)i / (float)steps;
            class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(level, start.method_46409(), look.method_46409(), false, includeFluids, false);
            if (raycastResult == null || raycastResult.getBlockPos().equals((Object)this.lastPosition)) continue;
            Rasterization3D.dda((class_2338)this.lastPosition, raycastResult.getBlockPos(), (x, y, z) -> {
                int[] offsets;
                int dx = x - this.lastPosition.method_10263();
                int dy = y - this.lastPosition.method_10264();
                int dz = z - this.lastPosition.method_10260();
                if (dy != 0) {
                    offsets = this.sphere;
                } else if (dx == 0) {
                    if (dz == 0) {
                        return;
                    }
                    if (dz == 1) {
                        offsets = this.cardinal[3];
                    } else {
                        if (dz != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        offsets = this.cardinal[1];
                    }
                } else {
                    if (dz != 0) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                    if (dx == 1) {
                        offsets = this.cardinal[2];
                    } else {
                        if (dx != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        offsets = this.cardinal[0];
                    }
                }
                for (int j = 0; j < offsets.length; j += 3) {
                    int x1 = offsets[j] + x;
                    int h2 = offsets[j + 1];
                    int z1 = offsets[j + 2] + z;
                    int fromY = y - h2;
                    int toY = y + h2;
                    boolean writeMax = false;
                    boolean updateMaxY = false;
                    int minY = this.heightMap.get(x1, z1) + 1;
                    int maxY = this.maxHeightMap.get(x1, z1);
                    if (maxY == Integer.MIN_VALUE) {
                        maxY = level.method_8624(class_2902.class_2903.field_13197, x1, z1) - 1;
                        writeMax = true;
                    }
                    if (fromY < minY) {
                        fromY = minY;
                    }
                    if (toY >= maxY) {
                        toY = maxY;
                        updateMaxY = true;
                    }
                    for (int y1 = toY; y1 >= fromY; --y1) {
                        if (!this.checked.add(x1, y1, z1)) continue;
                        this.maskContext.reset();
                        if (!this.maskContext.getBlockState(x1, y1, z1).method_51366() || this.maskContext.getBlockState(x1, y1, z1, 0, 1, 0).method_51366() || this.maskElement != null && !this.maskElement.test(this.maskContext, x1, y1, z1)) continue;
                        if (updateMaxY) {
                            maxY = y1;
                        }
                        this.heightMap.put(x1, z1, y1);
                        changed.value = true;
                        consumer.accept(x1, y1, z1);
                        break;
                    }
                    if (!writeMax && (!updateMaxY || maxY >= toY)) continue;
                    this.maxHeightMap.put(x1, z1, maxY);
                }
                this.lastPosition.method_10103(x, y, z);
            });
        }
        this.lastLookDirection = lookDirection;
        return changed.value;
    }
}

